<?php
require_once __DIR__ . "/config.php"; // Debe definir DATA_DIR y (opcional) allow_json()
if (function_exists('allow_json')) { allow_json(); }
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { exit; }

define("VOUCH_FILE", DATA_DIR . "/vouchers.json");

function load_store(){
  if (!file_exists(VOUCH_FILE)) {
    @file_put_contents(VOUCH_FILE, json_encode(["vouchers"=>[]], JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
  }
  $raw = @file_get_contents(VOUCH_FILE);
  $db = $raw ? json_decode($raw, true) : ["vouchers"=>[]];
  if (!isset($db["vouchers"]) || !is_array($db["vouchers"])) $db["vouchers"] = [];
  return $db;
}
function save_store($db){
  return @file_put_contents(VOUCH_FILE, json_encode($db, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
}
function rnd_code($len=6){
  $a = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
  $s = '';
  for($i=0;$i<$len;$i++){ $s .= $a[random_int(0, strlen($a)-1)]; }
  return $s;
}

$method = $_SERVER["REQUEST_METHOD"] ?? "GET";

if ($method === "GET") {
  $db = load_store();
  echo json_encode(["ok"=>true, "vouchers"=>$db["vouchers"]]);
  exit;
}

if ($method === "POST") {
  // Acepta JSON o x-www-form-urlencoded
  $raw = file_get_contents("php://input");
  $b = json_decode($raw, true);
  if (!$b) $b = $_POST;

  // ----- ELIMINAR -----
  // { action:"delete", code:"XYZ" }
  if (isset($b["action"]) && $b["action"] === "delete") {
    $code = trim($b["code"] ?? "");
    if ($code === "") { http_response_code(400); echo json_encode(["ok"=>false,"error"=>"CODE_REQUIRED"]); exit; }
    $db = load_store();
    $before = count($db["vouchers"]);
    $db["vouchers"] = array_values(array_filter($db["vouchers"], function($v) use ($code){
      return strcasecmp($v["code"] ?? "", $code) !== 0;
    }));
    $after = count($db["vouchers"]);
    if (!save_store($db)) { http_response_code(500); echo json_encode(["ok"=>false,"error"=>"WRITE_FAIL"]); exit; }
    echo json_encode(["ok"=>true,"deleted"=>($before-$after)]);
    exit;
  }

  // ----- CREACIÓN MASIVA -----
  if (isset($b["count"])) {
    $count = max(1, intval($b["count"]));
    $prefix = trim($b["prefix"] ?? "VIP");
    $days   = max(1, intval($b["days_valid"] ?? $b["days"] ?? 30));
    $max_uses = max(1, intval($b["max_uses"] ?? 1));
    $notes  = trim($b["notes"] ?? "");
    $length = max(4, intval($b["length"] ?? 6));
    $db = load_store();
    $codes = [];
    for ($i=0; $i<$count; $i++){
      do {
        $code = $prefix . rnd_code($length);
        $exists = false;
        foreach ($db["vouchers"] as $v){ if (strcasecmp($v["code"], $code)===0) { $exists=true; break; } }
      } while($exists);

      $db["vouchers"][] = [
        "code" => $code,
        "expires_at" => gmdate("c", time() + $days*86400),
        "used" => false,
        "times_redeemed" => 0,
        "last_redeemed_at" => null,
        "max_uses" => $max_uses,
        "notes" => $notes
      ];
      $codes[] = $code;
    }
    if (!save_store($db)) { http_response_code(500); echo json_encode(["ok"=>false,"error"=>"WRITE_FAIL"]); exit; }
    echo json_encode(["ok"=>true, "created"=>count($codes), "codes"=>$codes]);
    exit;
  }

  // ----- CREAR / EDITAR UNO -----
  $code = trim($b["code"] ?? "");
  if ($code === "") { http_response_code(400); echo json_encode(["ok"=>false, "error"=>"CODE_REQUIRED"]); exit; }

  $days = isset($b["days"]) && $b["days"]!=='' ? intval($b["days"]) : null;
  $expires_at = trim($b["expires_at"] ?? "");
  $reset_used = !empty($b["reset_used"]);
  $notes = isset($b["notes"]) ? trim($b["notes"]) : null;

  $db = load_store();
  $idx = -1;
  foreach ($db["vouchers"] as $i => $v) {
    if (strcasecmp($v["code"] ?? "", $code) === 0) { $idx = $i; break; }
  }

  if ($idx === -1) {
    $db["vouchers"][] = [
      "code" => $code,
      "expires_at" => $expires_at !== "" ? $expires_at : gmdate("c", time()+ (is_null($days)? 30*86400 : $days*86400)),
      "used" => false,
      "times_redeemed" => 0,
      "last_redeemed_at" => null,
      "max_uses" => intval($b["max_uses"] ?? 1),
      "notes" => $notes ?? ""
    ];
  } else {
    $v = $db["vouchers"][$idx];
    if (!is_null($days)) {
      $base = strtotime($v["expires_at"] ?? "") ?: time();
      if ($base < time()) $base = time();
      $v["expires_at"] = gmdate("c", $base + $days*86400);
    }
    if ($expires_at !== "") $v["expires_at"] = $expires_at;
    if ($reset_used) $v["used"] = false;
    if (!is_null($notes)) $v["notes"] = $notes;
    if (isset($b["max_uses"]) && $b["max_uses"]!=='') $v["max_uses"] = max(1, intval($b["max_uses"]));
    $db["vouchers"][$idx] = $v;
  }

  if (!save_store($db)) { http_response_code(500); echo json_encode(["ok"=>false,"error"=>"WRITE_FAIL"]); exit; }
  echo json_encode(["ok"=>true]);
  exit;
}

http_response_code(405); echo json_encode(["ok"=>false,"error"=>"METHOD_NOT_ALLOWED"]);