<?php
header("Content-Type: application/json; charset=utf-8");
header("Cache-Control: no-cache, no-store, must-revalidate");

// Archivo destino (JSON con las URLs)
$file = __DIR__ . "/../data/banners.json";

// Leer body JSON
$raw = file_get_contents("php://input");
$input = json_decode($raw, true);
if (!$input || !isset($input["url"])) {
    echo json_encode(["success" => false, "error" => "Falta parámetro 'url'"]);
    exit;
}

$url = trim($input["url"]);

// Validación sencilla de URL
if (!filter_var($url, FILTER_VALIDATE_URL)) {
    echo json_encode(["success" => false, "error" => "URL inválida"]);
    exit;
}

// Asegurar que exista el archivo
if (!file_exists($file)) {
    @file_put_contents($file, "[]");
}

$fp = fopen($file, "c+");
if (!$fp) {
    echo json_encode(["success" => false, "error" => "No se pudo abrir el archivo"]);
    exit;
}

// Bloqueo para escritura segura
flock($fp, LOCK_EX);

// Leer contenido actual
$size = filesize($file);
if ($size === 0) {
    $data = [];
} else {
    $json = fread($fp, $size);
    $data = json_decode($json, true);
    if (!is_array($data)) $data = [];
}

// Evitar duplicados (al inicio de la lista)
$data = array_values(array_filter($data, function($u) use ($url) { return $u !== $url; }));
array_unshift($data, $url);

// Limitar a 50 entradas para que no crezca indefinidamente
$data = array_slice($data, 0, 50);

// Reposicionar puntero y truncar
ftruncate($fp, 0);
rewind($fp);
fwrite($fp, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
fflush($fp);
flock($fp, LOCK_UN);
fclose($fp);

echo json_encode(["success" => true, "count" => count($data)]);
