<script>
  // ===== PERFIL (robusto: acepta ts, ms o ISO) =====
  async function loadAccount(){
    try{
      const code = localStorage.getItem('tv360_voucher_code') || '';
      const paid = localStorage.getItem('tv360_paid')==='yes';
      const pillBtn = document.getElementById('acctOpen');
      if(!code || !paid){ if(pillBtn) pillBtn.style.display='none'; return; }

      const r = await fetch('api/profile.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({code, device_id: getDeviceId()})
      });
      const j = await r.json().catch(()=>null);
      const modal = document.getElementById('acctModal');

      // Parser de fecha flexible
      const parseExpiry = (obj)=>{
        if(!obj) return null;
        if (typeof obj.expires_ts === 'number' && obj.expires_ts > 0){
          return new Date(obj.expires_ts * 1000);
        }
        if (typeof obj.expires_ms === 'number' && obj.expires_ms > 0){
          return new Date(obj.expires_ms);
        }
        const iso = obj.expires_iso || obj.expires;
        if (typeof iso === 'string' && iso.trim()){
          const d = new Date(iso);
          if (!isNaN(d.getTime())) return d;
        }
        return null;
      };

      const expDate = parseExpiry(j || {});
      const now = new Date();
      const activeFromBackend = !!(j && j.ok === true);
      // Si no viene ok, infiere por la fecha (si existe y es futura)
      const activeInferred = !!(expDate && expDate.getTime() > now.getTime());
      const isActive = activeFromBackend || activeInferred;

      // Calcula días restantes si no llegan
      let daysLeft = (j && typeof j.days_left === 'number') ? j.days_left : null;
      if (daysLeft === null){
        if (expDate){
          const diff = expDate.getTime() - now.getTime();
          daysLeft = Math.max(0, Math.ceil(diff / (1000*60*60*24)));
        } else {
          daysLeft = 0;
        }
      }

      const fmtDate = (d)=>{
        if(!d) return '—';
        return d.toLocaleString('es-ES', {year:'numeric', month:'long', day:'numeric'});
      };

      // Pinta UI
      document.getElementById('acctLabel').textContent = isActive
        ? ('Vence: ' + fmtDate(expDate))
        : 'Vencido';
      document.getElementById('acctMsg').textContent   = isActive
        ? 'Tu suscripción está activa.'
        : 'Tu suscripción no está activa.';
      document.getElementById('acctExpire').textContent= fmtDate(expDate);
      document.getElementById('acctDays').textContent  = daysLeft;
      document.getElementById('acctDev').textContent   = (j && j.device_id) || getDeviceId();
      document.getElementById('acctCode').textContent  = (j && j.code) || code;
      pillBtn.style.display='inline-block';

      document.getElementById('acctOpen')?.addEventListener('click', ()=>{ modal.style.display='flex'; });
      document.getElementById('acctClose')?.addEventListener('click', ()=>{ modal.style.display='none'; });
    }catch(e){
      // En caso de error, al menos mostramos el pill para poder abrir el modal
      const pillBtn = document.getElementById('acctOpen');
      if (pillBtn) pillBtn.style.display='inline-block';
    }
  }
</script>