<?php
require_once __DIR__ . "/config.php";
if (function_exists('allow_json')) { allow_json(); }

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { exit; }

/*
  Entrada:  JSON {"code":"VIP123"}
  Salida OK: {"ok":true, "expires_at":"2025-12-31T23:59:59Z"}
  Salida NO: {"ok":false, "error":"code_required|vouchers_file_missing|not_found|inactive|expired|open_fail|lock_fail"}
*/

$vouchersFile = DATA_DIR . "/vouchers.json";

$raw = file_get_contents("php://input");
$in  = json_decode($raw, true);
$code = trim((string)($in["code"] ?? ""));
if ($code === '') { echo json_encode(["ok"=>false,"error"=>"code_required"]); exit; }

if (!file_exists($vouchersFile)) { echo json_encode(["ok"=>false,"error"=>"vouchers_file_missing"]); exit; }

$fp = @fopen($vouchersFile, "r");
if (!$fp) { echo json_encode(["ok"=>false,"error"=>"open_fail"]); exit; }
if (!flock($fp, LOCK_SH)) { fclose($fp); echo json_encode(["ok"=>false,"error"=>"lock_fail"]); exit; }

$rawdb = stream_get_contents($fp);
flock($fp, LOCK_UN); fclose($fp);

$db = $rawdb ? json_decode($rawdb, true) : [];
if (!is_array($db)) $db = [];
$rows = isset($db["vouchers"]) && is_array($db["vouchers"]) ? $db["vouchers"] : [];

$found = null;
$ucode = strtoupper(trim($code));
foreach ($rows as $v) {
  $vc = isset($v["code"]) ? strtoupper(trim((string)$v["code"])) : '';
  if ($vc !== '' && $vc === $ucode) { $found = $v; break; }
}
if (!$found) { echo json_encode(["ok"=>false,"error"=>"not_found"]); exit; }

$now    = time();
$exp_ts = isset($found["expires_at"]) ? strtotime((string)$found["expires_at"]) : 0;
$active = array_key_exists("active",$found) ? (bool)$found["active"] : true;

if (!$active) { echo json_encode(["ok"=>false,"error"=>"inactive"]); exit; }
if ($exp_ts>0 && $exp_ts<$now) { echo json_encode(["ok"=>false,"error"=>"expired"]); exit; }

echo json_encode(["ok"=>true, "expires_at"=>$found["expires_at"] ?? null]);