
/* Banner strip loader */
(async function(){
  function el(tag, attrs={}, children=[]){
    const e=document.createElement(tag);
    for(const [k,v] of Object.entries(attrs)){ if(k==='class') e.className=v; else if(k==='style') e.style.cssText=v; else e.setAttribute(k,v) }
    for(const c of children){ e.append(c) }
    return e;
  }
  async function getBanners(){
    // Try API, then fallback to local JSON, then inline placeholders
    try{
      const r=await fetch('api/banner_get.php', {cache:'no-store'});
      if(r.ok){ const t=await r.text(); try{ return JSON.parse(t) }catch{ return [] } }
    }catch(_){}
    try{
      const r=await fetch('data/banners.json', {cache:'no-store'});
      if(r.ok) return await r.json();
    }catch(_){}
    // placeholders
    return ['assets/banners/sample1.png','assets/banners/sample2.png','assets/banners/sample3.png'];
  }

  const host = document.querySelector('[data-banner-host]');
  if(!host) return;
  const urls = (await getBanners()).filter(Boolean);
  if(!urls.length) return;

  // Build track with duplicated sequence for seamless loop
  const track = el('div', {class:'banner-track'});
  const makeItems = () => urls.map(u => el('a', {class:'banner-item', href:u, target:'_blank', rel:'noopener'}, [el('img',{src:u, alt:'banner'})]));
  for(const it of makeItems()) track.append(it);
  for(const it of makeItems()) track.append(it.cloneNode(true)); // duplicate

  // Append and measure width to set animation distance and speed
  host.classList.add('banner-strip');
  host.append(track);

  function update(){
    const totalWidth = Array.from(track.children).slice(0, urls.length).reduce((w, node)=> w + node.getBoundingClientRect().width + parseFloat(getComputedStyle(track).gap||0), 0);
    track.style.setProperty('--loop-width', totalWidth + 'px');
    // Duration proportional to width for constant pixel speed (100px/sec)
    track.style.animationDuration = Math.max(8, Math.round(totalWidth/100)) + 's';
  }
  const ro = new ResizeObserver(update);
  ro.observe(host);
  window.addEventListener('load', update);
  setTimeout(update, 300);
})();
