<?php
require_once __DIR__ . "/config.php";
if (function_exists('allow_json')) { allow_json(); }

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { exit; }

function read_code_from_request(): string {
  $raw = file_get_contents("php://input") ?: '';
  $ct  = $_SERVER['CONTENT_TYPE'] ?? '';

  if (stripos($ct, 'application/json') !== false) {
    $b = json_decode($raw, true);
    if (is_array($b) && isset($b['code'])) return trim((string)$b['code']);
  }
  parse_str($raw, $form);
  if (isset($form['code'])) return trim((string)$form['code']);
  if (isset($_POST['code'])) return trim((string)$_POST['code']);
  return '';
}
function json_fail(string $error){ echo json_encode(["ok"=>false,"error"=>$error],JSON_UNESCAPED_UNICODE); exit; }

$code = read_code_from_request();
if ($code === '') json_fail("code_required");

if (defined('PAY_CODE') && $code === PAY_CODE) {
  echo json_encode([
    "ok"=>true,"mode"=>"fixed","code"=>$code,"expires_at"=>null,
    "times_redeemed"=>0,"max_uses"=>1,"remaining"=>1
  ], JSON_UNESCAPED_UNICODE); exit;
}

$vouchersFile = DATA_DIR . "/vouchers.json";
if (!file_exists($vouchersFile)) json_fail("vouchers_file_missing");

$fp = @fopen($vouchersFile, "c+");
if (!$fp) json_fail("open_fail");
if (!flock($fp, LOCK_EX)) { fclose($fp); json_fail("lock_fail"); }

clearstatcache(true, $vouchersFile);
$size  = filesize($vouchersFile);
$rawdb = ($size && $size>0) ? fread($fp,$size) : '';
$db    = $rawdb ? json_decode($rawdb,true) : [];
if (!is_array($db)) $db = [];
if (!isset($db["vouchers"]) || !is_array($db["vouchers"])) $db["vouchers"] = [];

$idx = -1; $ucode = strtoupper(trim($code));
for ($i=0; $i<count($db["vouchers"]); $i++) {
  $vc = isset($db["vouchers"][$i]["code"]) ? strtoupper(trim((string)$db["vouchers"][$i]["code"])) : '';
  if ($vc !== '' && $vc === $ucode) { $idx = $i; break; }
}
if ($idx === -1) { flock($fp,LOCK_UN); fclose($fp); json_fail("not_found"); }

$v =& $db["vouchers"][$idx];

$now      = time();
$exp_ts   = isset($v["expires_at"]) ? strtotime((string)$v["expires_at"]) : 0;
$active   = array_key_exists("active",$v) ? (bool)$v["active"] : true;
$max_uses = isset($v["max_uses"]) ? max(1,(int)$v["max_uses"]) : 1;

$times_redeemed = 0;
if (isset($v["times_redeemed"])) $times_redeemed = max(0,(int)$v["times_redeemed"]);
elseif (isset($v["used"])) $times_redeemed = is_bool($v["used"]) ? ($v["used"]?1:0) : max(0,(int)$v["used"]);

if (!$active) { flock($fp,LOCK_UN); fclose($fp); json_fail("inactive"); }
if ($exp_ts>0 && $exp_ts<=$now){ flock($fp,LOCK_UN); fclose($fp); json_fail("expired"); }
if ($times_redeemed >= $max_uses){ flock($fp,LOCK_UN); fclose($fp); json_fail("max_uses"); }

$times_redeemed++;
$v["times_redeemed"]   = $times_redeemed;
$v["used"]             = $times_redeemed;
$v["last_redeemed_at"] = gmdate("c");

ftruncate($fp,0); rewind($fp);
fwrite($fp, json_encode($db, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
fflush($fp); flock($fp,LOCK_UN); fclose($fp);

$remaining = max(0, $max_uses - $times_redeemed);
echo json_encode([
  "ok"=>true, "mode"=>"voucher", "code"=>$v["code"] ?? $code,
  "expires_at"=>$v["expires_at"] ?? null,
  "times_redeemed"=>$times_redeemed, "max_uses"=>$max_uses, "remaining"=>$remaining
], JSON_UNESCAPED_UNICODE);