<?php
require_once __DIR__ . "/config.php"; allow_json();

if (($_SERVER['REQUEST_METHOD'] ?? 'GET') === 'OPTIONS') { exit; }

$input = file_get_contents("php://input");
$url = '';
$ct = $_SERVER['CONTENT_TYPE'] ?? '';
if (stripos($ct,'application/json')!==false) {
  $b = json_decode($input, true);
  $url = $b['url'] ?? '';
} else {
  $url = $_POST['url'] ?? ($_GET['url'] ?? '');
}

if (!$url) { http_response_code(400); echo json_encode(["error"=>"URL_REQUIRED"]); exit; }

// Solo permitir http:// y que termine en .m3u o .m3u8 (lista)
$parts = @parse_url($url);
if (!$parts || strtolower($parts['scheme'] ?? '') !== 'http' || !preg_match('/\.(m3u|m3u8)($|\?)/i', $parts['path'] ?? '')) {
  http_response_code(400); echo json_encode(["error"=>"URL_NOT_ALLOWED","hint"=>"Solo http:// y .m3u/.m3u8"]); exit;
}

// Descargar con cURL
$ch = curl_init();
curl_setopt_array($ch, [
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_CONNECTTIMEOUT => 8,
  CURLOPT_TIMEOUT => 20,
  CURLOPT_USERAGENT => "TV360-IPTV/1.0",
]);
$body = curl_exec($ch);
$err  = curl_error($ch);
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($body === false || $code < 200 || $code >= 300) {
  http_response_code(502);
  echo json_encode(["error"=>"FETCH_FAILED","code"=>$code,"detail"=>$err]); exit;
}

// Reusar la lógica de import_m3u: le pasamos el contenido como si fuera POST JSON
// Aquí replicamos el parseo de import_m3u, pero con el mismo filtro.

$db_raw = @file_get_contents(CATALOG);
$db = $db_raw ? json_decode($db_raw, true) : ["movies"=>[], "channels"=>[]];
$lines = preg_split("/\r?\n/", $body);
$pending = ["name"=>"Canal","logo"=>"","group"=>""];
$added = 0;

function is_allowed_m3u8($u){
  $parts = @parse_url(trim($u));
  if (!$parts || !isset($parts['scheme']) || !isset($parts['path'])) return false;
  if (strtolower($parts['scheme']) !== 'http') return false; // solo HTTP
  return (bool)preg_match('/\.m3u8($|\?)/i', $parts['path']);
}

foreach ($lines as $line) {
  $line = trim($line);
  if ($line === '' || strpos($line, '#EXTM3U') === 0) continue;
  if (stripos($line, '#EXTINF') === 0) {
    if (preg_match('/,(.*)$/', $line, $m)) $pending['name'] = trim($m[1]);
    if (preg_match('/tvg-logo="([^"]+)"/i', $line, $m)) $pending['logo'] = $m[1];
    if (preg_match('/group-title="([^"]+)"/i', $line, $m)) $pending['group'] = $m[1];
    continue;
  }
  if ($line[0] === '#') continue;
  if (is_allowed_m3u8($line)) {
    $db["channels"][] = [
      "id" => uniqid(),
      "name" => $pending["name"] ?: "Canal",
      "url" => $line,
      "cat" => $pending["group"] ?: "",
      "thumb" => $pending["logo"] ?: "",
      "access" => "gratis"
    ];
    $pending = ["name"=>"Canal","logo"=>"","group"=>""];
    $added++;
  }
}

file_put_contents(CATALOG, json_encode($db, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
echo json_encode(["ok"=>true, "added"=>$added, "total"=>count($db["channels"])]);
?>