<?php
require_once __DIR__ . "/config.php";
header("Content-Type: application/x-mpegURL; charset=utf-8");
header("Cache-Control: no-store");
$db = json_decode(@file_get_contents(CATALOG), true);
$out = "#EXTM3U\n";
foreach (($db["channels"] ?? []) as $c) {
  $title = $c["name"] ?? "Canal";
  $url = $c["url"] ?? "";
  if (!$url) continue;
  $logo = $c["thumb"] ?? "";
  $group = $c["cat"] ?? "";
  $attrs = [];
  if ($logo) $attrs[] = 'tvg-logo="' . str_replace('"','\"',$logo) . '"';
  if ($group) $attrs[] = 'group-title="' . str_replace('"','\"',$group) . '"';
  $out .= "#EXTINF:-1 " . implode(" ", $attrs) . "," . $title . "\n" . $url . "\n";
}
echo $out;
?>