<?php
require_once __DIR__ . "/config.php";
header("Content-Type: application/json; charset=utf-8");
$res = [
  "DATA_DIR" => DATA_DIR,
  "CATALOG"  => CATALOG,
  "exists"   => [
    "data_dir" => is_dir(DATA_DIR),
    "catalog"  => file_exists(CATALOG),
  ],
  "writable" => [
    "data_dir" => is_writable(DATA_DIR),
    "catalog"  => file_exists(CATALOG) ? is_writable(CATALOG) : is_writable(dirname(CATALOG)),
  ],
  "size_catalog" => file_exists(CATALOG) ? filesize(CATALOG) : 0,
  "last_error_log_exists" => file_exists(LOG_FILE),
  "php_user" => get_current_user(),
];
/* prueba de escritura mínima */
$probe = @file_put_contents(DATA_DIR."/.__probe", date('c')."\n", FILE_APPEND);
$res["write_probe_ok"] = $probe !== false;
echo json_encode($res, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE);